/*
 * Copyright (c) 2008, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Willow Garage, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Author: Brian Gerkey */

/*
 * Check that the master is running
 */

#include <gtest/gtest.h>

#include <time.h>
#include <stdlib.h>

#include "ros/ros.h"

#include "xmlrpcpp/XmlRpc.h"

using namespace XmlRpc;

bool g_should_exist = true;

#ifdef _WIN32
int setenv(const char *name, const char *value, int overwrite)
{
  if(!overwrite)
  {
    size_t envsize = 0;
    const errno_t errcode = getenv_s(&envsize, NULL, 0, name);
    if(errcode || envsize)
      return errcode;
  }
  return _putenv_s(name, value);
}
#endif

TEST(CheckMaster, checkMaster)
{
  ASSERT_EQ(ros::master::check(), g_should_exist);
}

int main(int argc, char** argv)
{
  testing::InitGoogleTest(&argc, argv);

  ros::V_string args;
  ros::removeROSArgs(argc, argv, args);

  if (args.size() != 2)
  {
    ROS_ERROR("Usage: check_master [yes|no]");
    return 1;
  }

  if (args[1] == "no")
  {
    g_should_exist = false;
    setenv("ROS_MASTER_URI", "http://invalid_host_name_blahahahahahahahahahahaha:11311", 1);
    std::cout << getenv("ROS_MASTER_URI") << std::endl;
  }

  ros::init(argc, argv, "check_master");

  return RUN_ALL_TESTS();
}
