% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writer.R
\name{file_writer}
\alias{file_writer}
\title{Lazy File Writer}
\usage{
file_writer(path, append = FALSE)
}
\arguments{
\item{path}{file name or path on disk}

\item{append}{open file in append mode}
}
\value{
Function with signature \code{writer(data = raw(), close = FALSE)}
}
\description{
Generates a closure that writes binary (raw) data to a file.
}
\details{
The writer function automatically opens the file on the first write and closes when
it goes out of scope, or explicitly by setting \code{close = TRUE}. This can be used
for the \code{data} callback in \code{multi_add()} or \code{curl_fetch_multi()} such
that we only keep open file handles for active downloads. This prevents running out
of file descriptors when performing thousands of concurrent requests.
}
\examples{
# Doesn't open yet
tmp <- tempfile()
writer <- file_writer(tmp)

# Now it opens
writer(charToRaw("Hello!\n"))
writer(charToRaw("How are you?\n"))

# Close it!
writer(charToRaw("All done!\n"), close = TRUE)

# Check it worked
readLines(tmp)
}
